set more off
global path_in ""
global path_temp ""
global path_out ""

* Store between-industry predictions from Table 9

**1. Data preparation
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/
	
	preserve
		**Store mean VA shares by country-industry
		keep country code year VA
		bysort country year: egen totVA=sum(VA)
		gen VAshare=VA/totVA
		collapse (mean) VAshare, by(country code)
		table country, c(sum VAshare)
	save $path_temp\temp_meanVA, replace
	restore

	preserve
		**Store mean log laborshare by country-industry
		keep country code year weight* VA laborshare
		replace laborshare=laborshare/100
		gen lnlaborshare=ln(laborshare)
		collapse (mean) lnlaborshare, by(country code)
		save $path_temp\temp_meanLS, replace
	restore
	
clear	

**2. Predicted between-industry change in laborshare by country-industry-year
use $path_out\Table9_predictions_within, clear	
	keep country code code_hier decade sectorgroup year DYn*

	*Total predicted output changes across years within countries, over 37-year period
	gen nryrs=1
	collapse (sum) DYn* nryrs, by(country code code_hier)

	*Merge in average VA share and lnlaborshare
	merge 1:1 country code using $path_temp\temp_meanVA.dta
	drop _
	merge 1:1 country code using $path_temp\temp_meanLS.dta 
	drop _
	rename VAshare omega_ic
	
	*Convert percentage change in nominal VA to changes in VA shares	
		*Calculate % change in VA by country-industry
	gen DVA=exp(DYn_net/100) /*total % change in output by country-industry*/
		*Calculate change in VA share by country-industry
	gen omega_ic_hat=omega_ic*DVA
	bysort country: egen totomega_ic_hat=sum(omega_ic_hat)
	gen Domega_ic_hat=(omega_ic_hat/totomega_ic_hat)-omega_ic
	table code, c(mean Domega_ic_hat)
		*Annualize and express as 100 x log change	
		replace Domega_ic_hat=Domega_ic_hat/nryrs*100
	
		table country, c(mean Domega_ic_hat sum Domega_ic_hat ) /*share changes sum to zero within countries*/
		table code, c(mean Domega_ic_hat) /*Predicted VA share change by industry, unweighted average across countries*/
		
	*Calculate implied laborshare change by country from VA change
	gen DLS_net_ind=Domega_ic_hat*lnlaborshare
	bysort country: egen DLS_net=sum(DLS_net)

	keep country code code_hier DLS_net_ind DLS_net
	label var DLS_net "Annual predicted log laborshare change from between effect by country, log points"
	label var DLS_net_ind "Contribution of industry"
save $path_out\Table9_predictions_betw, replace

**3. Predicted total between-industry change in laborshare, aggregated
*Calculating weighted average across countries
use $path_out\Table9_predictions_betw, clear
	*remove industry dimension
	duplicates drop country, force
	drop code
	
	*Merge in country weights
	merge 1:1 country using $path_in\country_weights
	drop _
	
	*Construct weighted average across countries
	replace country="all"
	collapse (mean) DLS_net [w=weight_ls], by(country)
	rename DLS_net DLS
	gen type = "e_betw"
save $path_out\Table9_predictions_betw_tot,	replace
	

*erasing temporary files
	erase $path_temp\temp_meanVA.dta
	erase $path_temp\temp_meanLS.dta
	
